s        \   d                                       bp2329      Burster Resistomat Type 2329                    ViInt16     ViInt32    ViUInt16    ViUInt32    ViReal64     	  ViInt16[]     	  ViInt32[]     
  	ViReal64[]      ViRsrc   	 	ViSession       ViChar[]     ViStatus   	 	ViBoolean      	 
ViBoolean[]        Instrument Name:Burster Resistomat Typ 2329

  Description:   This instrument module provides
                 RS232 support for  Resistomat
                 Typ 2329 from Burster.
                 The module contains the following
                 functions:

  (1) Initialize Functions
      Initialize the GPIB
      Initialize the RS232-Port

  (2) Configure  the device   - Range
                              - Display
                              - Temp.Compensation
                              - Device Access
                              - Printer
                              - Store/Load Config.

  (3) Measurement Functions
      Start Measurement
      Read Measurement value
      Stop Measurement


  (4) Comparartor Functions
      Configure Comparator Mode
      Configure 2 Limit Mode
      Configure 4 Limit Mode
      Read Comparator Reports
      Clear Comparator

  (5) Envelope (Min/Max-Functions)
      Envelope State
      Read Envalope Report  
      Clear Enevlope

  (6) Datalogger
      Configure Datalogger
      Datalogger State
      Clear Datalogger Block
      Select Active Datalogger Block
      Read 20 Datalogger Values 
      Read Num. of Datalogger Block
      Read Datalogger Evaluation Values

  (7) System Functions
      Set Register
      Get Register
      Set Device System Date and Time
      Read the system error
      Control the keyboard
      
  (8) Calibration Functions


  (9) Close the instrument
      *********          Class Name:    Initialize

 Description:   Sets up all necessary functions
                for initializing the Resistomat.
    C     Panel Name:    Initialize Gpib

 Description:   Initializes the instrument by:
 1) finding an unused device in the device table
    using the supplied GPIB address
 2) device clear and RESET  (if desired)
 3) returns the ID-String of the instrument
 4) returns an instrument ID

 This is a multi-instrument driver, allowing
 multiple Resistomat 2304+2305 instruments to be
 controlled.
 During the initialization, the returned ID is
 based on the GPIB address.  This ID is used in
 all of the other functions to distinguish
 between multiple Resistomat 2304+2305
 instruments.    k     Panel Name:    Initialize Serial

 Description:   Initializes the instrument by:
 1) finding an unused device in the device table
    using the supplied serial group and user
    address
 2) device clear and RESET  (if desired)
 3) returns the ID-String of the instrument
 4) returns an instrument ID

 This is a multi-instrument driver, allowing
 multiple Resistomat 2304-2305 instruments to be
 controlled.
 During the initialization, the returned ID is
 based on the serial group and user address.
 This ID is used in all of the other functions
 to distinguish between multiple Resistomat 2304+
 2305 instruments.     j     Panel Name:    Local (GPIB only)

 Description:   Sets the  temporarily in
                local mode.
    /       Class Name:  Configure 

   Description: Class of functions for Configure
                the device of following parameters:

                - Configure the measurement 
                - Configure the range
                - Configure the display
                - Configure the comparator
                - Configure the min/max function        
                - Configure the temperature compensation
                - Configure the device scale
                - Configure the device access
                - Configure the printer function                 Panel Name:    Set Config Measurement

 Description:   Configure the instrument in
                following ways:

                            
                - Sets the average counts
                - Selects the average control
                - Selects the loading mode
                - Selects the measurement mode
                - Selects the 20 mV limit
                - Selects the measurement sequence
                - Selects the numbers of convert Cycles
         Panel Name:    Get Config Device

 Description:                               
                - Gets the average counts
                - Gets the average control
                - Gets the loading mode
                - Gets the measurement mode
                - Gets the 20 mV limit
                - Gets the measurement sequence
                - Gets the numbers of convert Cycles
           Class Name:  Config Range

   Description: Class of functions for Configure
                the range functions of the device
                of following parameters:

                - Configure the measurement range
                - Configure the auto range function
          Panel Name:    Set Config Range

 Description:   Configure the instrument range in
                following ways:

                - Selects the Auto range function
                  or sets the range manuall
     E     Panel Name:    Get Config Range

 Description:   Gets the range 

    	     Panel Name:    Set Config Auto Range

 Description:   Configure the instrument auto range
                function in
                following ways:

                - Sets the upper and lower range for
                  the auto range function of the device


          Panel Name:    Gets Config Auto Range

 Description:   Gets the upper and lower range for
                the auto range function of the device


           Class Name:  Config Display

   Description: Class of functions for Configure
                the display functions of the device
                of following parameters:

                - Configure the display options
                - Configure the display contrast
          Panel Name:    Set Config Display Mode

 Description:   Configure the instrument display mode
                following ways:

                - Selects the display mode
                - Selects the display resolution
                
          Panel Name:    Get Config Display Mode

 Description:   
                - Gets the display mode
                - Gets the display resolution
                
     x     Panel Name:    Set Config Display Options

 Descrpition:   Config the display options of the 
                device
     u     Panel Name:    Get Config Display Options

 Descrpition:   Get the display options of the 
                device
     X     Panel Name:    Set Config Display Contrast

 Descrpition:   Set the display contrast
     Y     Panel Name:    Get Config Display Contrast

 Descrpition:   Gets the display contrast
          Class Name:    Config Temperature Compensation

 Description:   Sets up all necessary config temperature 
                compensation functions for the device          Panel Name:    Set Config Temp. Compensation

 Descrpition:   Set the follow parameters:
                - toggle the state ON/OFF
                - Input the manual temperature

          Panel Name:    Get Config Temp. Compensation

 Descrpition:   
                - Gets the state 
                - Gets the manual temperature

          Panel Name:    Get Config Temp. Compensation

 Descrpition:   
                - Gets the state 
                - Gets the manual temperature

          Panel Name:    Set Config Scale PT100

 Description:   Scale the PT100 function

 Formula :      Rt = R0 *(1 + "a" * t + "b" * t^2 )          Panel Name:    Get Config Scale PT100

 Description:   Gets the scale parameter of the
                PT100 function

 Formula :      Rt = R0 *(1 + "a" * t + "b" * t^2 )          Panel Name:    Set Config Scale U/I Input

 Description:   Scale the U or I Input functions
                for the linearization curve          Panel Name:    Config Scale U/I Input

 Description:   Gets the scale the U or I Input
                functions for the linearization curve          Panel Name:    Set Config Temperature Coefficients

 Descrpition:   Config one of the ten temperature
                coefficents.          Panel Name:    Get Config Temperature Coefficients

 Descrpition:   Gets one of the ten temperature
                coefficents.          Panel Name:    Set Avtive Temperature Coefficients

 Descrpition:   Sets one of the ten temperature
                coefficents.     ~     Panel Name:    Get Active Temperature Coefficients

 Descrpition:   Get the active temperature
                coefficents.          Panel Name:    Set Config Device Access

 Description:   Configure the access to the device
                menues.

                
          Panel Name:    Config Device Access

 Description:   Configure the access to the device
                menues.

                
          Class Name:    Config Printer

 Description:   Sets up all necessary configure the
                printer functions for the device     U     Panel Name:    Set Config Printer State

 Description:   Start or stop the printer     Y     Panel Name:    Set Config Printer Mode

 Description:   Configure the printer options
     Y     Panel Name:    Set Config Printer Mode

 Description:   Configure the printer options
     S     Panel Name:    Reset Printer Counter

 Description:   Reset the printer counter
          Class Name:    Store/Load Configuration

 Description:   Sets up all necessary store/load  
                config. functions for the device     y     Panel Name:    Set Memory Labels

 Description:   Store the memory label to the
                specificies memory No.     {     Panel Name:    Get Memory Label

 Description:   Return the memory label from the
                specificies memory No.          Panel Name:    Store Memory No.

 Description:   Store the actual Parameters to
                the selected memory of the
                instrument
          Panel Name:    Get Memory No.

 Description:   Recall the actual Parameters to
                the selected memory of the
                instrument
    B       Class Name:  Measure

   Description: Class of functions for setting the
                following types of parameters:

                - Start the measurement
                - Read a value with the
                  unit from the device
                - Stop the measurement
                  unit from the device     G     Panel Name:    Measure Start

 Descrpition:   Start the measurement
     t     Panel Name:    Measure Read

 Descrpition:   Revieves measured values while
                a measurement is done     t     Panel Name:    Measure Read

 Descrpition:   Revieves measured values while
                a measurement is done     D     Panel Name:    Measure Stop

 Descrpition:   Stop the measurement     w     Class Name:    Comparator

 Description:   Sets up all necessary comparator
                functions for the device          Panel Name:    Set Comparator Mode

 Description:   Sets the Comparator State ON/OFF
                Config the relais mode
                Config the comparator fault mode
                                      (On Error)          Panel Name:    Get Comparator Mode

 Description:   Gets the Comparator State ON/OFF
                Config the relais mode
                Config the comparator fault mode
                                      (On Error)     x     Panel Name:    Set Two Limit Comparator

 Description:   Configure the two limit comparator
                functions     s     Panel Name:    Get Two Limit Comparator

 Description:   Gets the two limit comparator
                parameter     z     Panel Name:    Set Four Limit Comparator

 Description:   Configure the four limit
                comparator functions     u     Panel Name:    Get Four Limit Comparator

 Description:   Gets the four limit
                comparator parameter    !     Panel Name:    Read 2 Limit Comparator Report

 Description:   Read the follow the comparator 
                values as integer
                
 - Value 1 (Num.of values < lower limit)
 - Value 2 (lower limit >= Num.of values <= upper limit)
 - Value 3 (Num.of values > upper limit)

    d     Panel Name:    Read 4 Limit Comparator Report

 Description:   Read the follow the comparator 
                values as integer
                
 - Value 1 (Num.of values < limit1)
 - Value 2 (limit1>= Num.of values < limit2)
 - Value 3 (limit2>= Num.of values < limit3)
 - Value 4 (limit3>= Num.of values < limit4)
 - Value 5 (Num.of values > limit4)
     O     Panel Name:    Clear Comparator 

 Description:   Clear the comparator datas          Class Name:    Envelope (Min/Max-Function)

 Description:   Sets up all necessary envelope 
                (min/max) functions for the device     T     Panel Name:    Set Envelope State

 Description:   Sets the Envelope State ON/OFF     M     Panel Name:    Get Envelope State

 Description:   Gets the Envelope State          Panel Name:    Read Envelope Report

 Description:   Read the follow the envelope 
                values as String

                - Minium Value
                - Maximum Value
                - Difference Value     K     Panel Name:    Clear Envelope 

 Description:   Clear the envelope datas     w     Class Name:    Datalogger

 Description:   Sets up all necessary datalogger
                functions for the device     Y     Panel Name:    Set Datalogger State

 Description:   Sets the datalogger state ON/OFF.     Y     Panel Name:    Get Datalogger State

 Description:   Gets the datalogger state ON/OFF.     J     Panel Name:    Set Datalogger Name

 Description:   Set datalogger Name     Q     Panel Name:    Get Config Datalogger

 Description:   Gets the datalogger name     U     Panel Name:    Set Datalogger Size

 Description:   Sets the datalogger block size     [     Panel Name:    Get Datalogger Block Size

 Description:   Gets the datalogger block size     W     Panel Name:    Set Config Datalogger

 Description:   Configure the datalogger modes     `     Panel Name:    Get Config Datalogger

 Description:   Gets the datalogger modes and parameter     X     Panel Name:    Clear Datalogger Block

 Description:   Clear the datalogger block no.     ]     Panel Name:    Set Active Datalogger Block

 Description:   Setect Active Datalogger Block     [     Panel Name:    Get Active Datalogger Block

 Description:   Gets Active Datalogger Block     h     Panel Name:    Read Datalogger Num.Of Counts

 Description:   Read the num. of counts from the block.          Panel Name:    Read Datalogger Block

 Description:   Read measure,date and time values 
                from the specificies block no.          Panel Name:    Read Datalogger Eval.Block

 Description:   Read evaluation values (min,max,mean,std-dev.,
                from the specificies block no.    p       Class Name:  System

   Description: Class of functions for setting the
                follow parameters:

                - Set/Reset the output register
                - Read the input register
                - Read the system error of device
                - Control the keyboard of the
                  decive
                - Set the device system date     R     Panel Name:   Set Output Register

 Descrpition:  Set/Reset the output register     K     Panel Name:   Get Register

 Descrpition:  Get the input register status     H     Panel Name:   System Date/Time

 Description:  Sets the System clock
     a     Panel Name:   System Error

 Description:  Reads the system error of the
               device     U     Panel Name:   System Keybroad

 Description:  Controls the keybroad of the device
    k       Class Name:  Calibration

   Description: Class of functions for setting the
                follow parameters:

                - Calibration all resistance ranges
                - Calibration 20mV Limit               
                - Calibration the voltage input
                - Calibration the current input
                - Calibration PT100 input     U     Panel Name:   Calibration State

 Descrpition:  Sets the calibration state ON/OFF.          Panel Name:   Calibration Resistance Range

 Descrpition:  This panel calibrate all possible
               resistance ranges     ^     Panel Name:   Calibration 20mV Mode

 Descrpition:  Specificies the 20mV Mode (High or Low)    C     Panel Name:   Calibration 20mV Init

 Descrpition:  Initialize the 20mV calibration.
               Before you must select the 20mV mode.
               Please measure the voltage about the 
               calibration resistance during both
               20mV modes. After this command enter 
               the resistance value and the low voltage
               and the high voltage to the device
               with following function.

               bp2329_cal_20mV(id,res_value,low_volatge,
                               high_voltage);
                
                         Panel Name:   Calibration 20mV 

 Descrpition:  This command enter the resistance value and the low voltage
               and the high voltage to the device.


          Panel Name:   Calibration Voltage Mode

 Descrpition:  Initialize the voltage calibration.
               Input 0V and sets the mode = low.
               Input 10V and sets the mode = high.
                          Panel Name:   Calibration Voltage

 Descrpition:  Enter the low voltage (0V) and the
               high voltage (10V) to finished the
               calibration of voltage.          Panel Name:   Calibration Current

 Descrpition:  Enter the current value (20mA)
               to finished the calibration of current.          Panel Name:   Calibration PT100 Mode

 Descrpition:  Calibrate the PT100 Input of the device.
               Enter the lwo and high value to
               calibrate the PT100 input.     S     Panel Name:   Calibration PT100

 Descrpition:  Initialize the PT100 calibration           Class Name:  SCPI

   Description: Class of functions for setting the
                follow parameters:

                - Send every SCPI-Message to a
                  slave 
                - Send "Query form" from SCPI-
                  Message and receive a answers
     g     Panel Name:   Send a SCPI-Message

 Descrpition:  Send every SCPI-Message to a
               slave           Panel Name:   Receive a SCPI-Message

 Descrpition:  Send "Query form" from SCPI-
               Message and receive a answers
               => Polling     <     Panel Name :  Close

 Descrpition:  Close the instrument
          Control Name:  Address

 Description:   Specifies the address on the GPIB
 to be used to communicate with the instrument.
 This value must correspond to the current
 internal setting of the instrument.

 Variable Type: Integer

 Valid Range:   0 to 30
    k     Control Name:   Timeout (seconds)

 Description:    Specifies  the timeout limit for
                 I/O operations.

 Variable Type:  Integer

 Valid Range:    0 - 5
                 0 = 100msec 
                 1 = 300msec 
                 2 = 1sec 
                 3 = 3sec 
                 4 = 10sec 
                 5 = 30sec 

 Default:        3sec          Control Name:  Reset

 Description:   If reset is on, a device clear and
 power on reset is done during initialization.

 Variable Type: Integer

 Valid Range:   0 to 1
                0  off
                1  on
          Control Name:  Instrument ID String

 Description:   Returns the ID-String of the
                instrument.

 Variable Type: String

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid GPIB Address
 -2     Invalid Reset

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator
    I        `    Address                           J p          Timeout                           L\           Reset                             M=      `    Instrument ID-String              M 9     `    Instrument ID                     O      `    Error                              9              /100ms 9 300ms 10 1 s 11 3 s 12 10 s 13 30 s 14   On 1 Off 0    	            	            	                Control Name:   COM-Port

 Description:    Specifies the COM-Port to be
                 used to communicate with the
                 instrument.

 Variable Type:  Integer

 Valid Values:   1 - COM1   (=> Adress 0x3f8 IRQ4)
                 2 - COM2   (=> Adress 0x2f8 IRQ3)
                 3 - COM3   (=> Adress 0x3e8 IRQ4)
                 4 - COM4   (=> Adress 0x2e8 IRQ3)

 Default:        1         Control Name:   Baud Rate

 Description:    Specifies the baud rate of the
                 RS232-Port to communicate with
                 the instrument. This value must
                 correspond to the current
                 internal setting of the
                 instrument.

 Variable Type:  Integer

 Valid Values:   1200,2400,4800,9600,19200 or 38400
                 baud

 Default:        9600    *     Control Name:   Time-out (seconds)

 Description:    Specifies  the time-out limit for
                 I/O operations.
                 A  value  of  0.0  will  disable
                 time-out altogether.

 Variable Type:  Double

 Valid Range:    0.060 to 100.0 seconds

 Default:        1.0          Control Name:  Instrument ID String

 Description:   Returns the ID-String of the
                instrument.

 Variable Type: String

    *     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.
          Control Name:  Reset

 Description:   If reset is on, a device clear and
 power on reset is done during initialization.

 Variable Type: Integer

 Valid Range:   0 to 1
                0 = off
                1 = on
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   COM-Port is out of range
       -2   Baud Rate is out of range
       -3   Time-out is out of range
       -4   Block Check parameter is out of range
       -5   Group Address is out of range
       -6   User Address is out of range
       -7   Reset Device is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    R & Y           COM-Port                          Tq &          Baud Rate                         V &z        Time-out (seconds)                WF  ,    `    Instrument ID-String              W       `    Instrument ID                     Y
           Reset                             Y    `    Error                                          1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8              @1200 1200 2400 2400 4800 4800 9600 9600 19200 19200 38400 38400 ?      @>      ?      ?                   	            	           On 1 Off 0    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    	     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator
    `        `    Instrument ID                     a8     `    Error                              1    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Average Control

 Description:   This parameter selects the type of
                Averaging

 Variable Type: Integer

 Valid Range:   0 = Moving
                1 = Repeat          Control Name:  Average Counts

 Description:   This parameter inputs the numbers
                of average counts

 Variable Type: Integer

 Valid Range:   1 - 9999          Control Name:  Measurement Mode

 Description:   This parameter is meant for
                changing between single and
                repetition measurements.

 Variable Type: Integer

 Valid Range:   0 = Single
                1 = Repetition         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Average Control
       -3   Invalid Average Counts
       -4   Invalid Loading Mode
       -5   Invalid Measurement Mode
       -6   Invalid 20 mV State
       -7   Invalid Measurement Sequence
       -8   Invalid Numbers of Convert Cycles

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  20 mV Limit

 Description:   Selects the range of the 20 mV
                Limit.

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = ON
    0     Control Name:  Measurement Sequence

 Description:   This parameter selects then measurement
                sequence.


 Variable Type: Integer

 Valid Range:   0 = Ref-Comp
                    (Zero measuremnet with current = 0)
                1 = None Comp
                    (Measurement without zero measurement)
                2 = Single Comp 
                    (Measurement with one zero measurement)
                3 = Standard
                    (Measurement with toggle between zero 
                     measurement and realy measurement)
          Control Name: Loading

 Description: This parameter selects the load to
              measured (mainly ohmic or mainly
              indictive resistance).

 Variable Type: Integer

 Valid Range:   0 = mainly ohmic
                1 = mainly inductive
          Control Name:  Number of Converts

 Description:   This parameter select the number of converts.


 Variable Type: Integer

 Valid Range:   0 = Minimum
                1 = Medium
                2 = Maximum
                3 = Standard
    c        `    Instrument ID                     d            Average Mode                      e 	     `    Average Counts                    fl z           Measurement Mode                  gl     `    Error                             k@ z           20mV Limit                        k zO         Measurement Sequence              n.           Loading                           o5 z         Num. of Converts Cycles            1    Repeat 1 Moving 0    1    Repetition 1 Single 0    	            On 1 Off 0              0Ref-Comp 0 None Comp 1 Single Comp 2 Standard 3    Inductive 1 Ohmic 0              (Minimum 0 Medium 1 Maximum 2 Standard 3   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Average Control

 Description:   This parameter gets the type of
                Averaging

 Variable Type: Integer

 Valid Range:   0 = Moving
                1 = Repeat          Control Name:  Average Counts

 Description:   This parameter gets the numbers
                of average counts

 Variable Type: Integer

 Valid Range:   1 - 9999          Control Name:  Measurement Mode

 Description:   This parameter gets the 
                measurements mode.

 Variable Type: Integer

 Valid Range:   0 = Single
                1 = Repetition         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Average Control
       -3   Invalid Average Counts
       -4   Invalid Loading Mode
       -5   Invalid Measurement Mode
       -6   Invalid 20 mV State
       -7   Invalid Measurement Sequence
       -8   Invalid Numbers of Convert Cycles

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  20 mV Limit

 Description:   Gets the range of the 20 mV
                Limit.

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = ON
    -     Control Name:  Measurement Sequence

 Description:   This parameter gets then measurement
                sequence.


 Variable Type: Integer

 Valid Range:   0 = Ref-Comp
                    (Zero measuremnet with current = 0)
                1 = None Comp
                    (Measurement without zero measurement)
                2 = Single Comp 
                    (Measurement with one zero measurement)
                3 = Standard
                    (Measurement with toggle between zero 
                     measurement and realy measurement)
          Control Name: Loading

 Description: This parameter gets the load to
              measured (mainly ohmic or mainly
              indictive resistance).

 Variable Type: Integer

 Valid Range:   0 = mainly ohmic
                1 = mainly inductive
          Control Name:  Number of Converts

 Description:   This parameter gets the number of converts.


 Variable Type: Integer

 Valid Range:   0 = Minimum
                1 = Medium
                2 = Maximum
                3 = Standard
    r        `    Instrument ID                     t       `    Average Mode                      t      `    Average Counts                    u z      `    Measurement Mode                  vV     `    Error                             z* z      `    20mV Limit                        z z    `    Measurement Sequence              }      `    Loading                           ~ z    `    Num. of Converts Cycles            1    	            	            	            	            	            	            	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Range


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

         Control Name:  Range

 Description:   This parameter activates or de-
                activates automatic measuremnet
                range selection and selects the
                desired measurement range.

 Variable Type: Integer

 Valid Range:   0 = Auto
                1 = 200 mOhm
                2 = 2    Ohm
                3 = 20   Ohm
                4 = 200  Ohm
                5 = 2   KOhm
                6 = 20  KOhm
                7 = 200 KOhm    M        `    Instrument ID                     ~     `    Error                             i c-          Range                              1    	                       JAuto 0 200 mOhm 1 2 Ohm 2 20 Ohm 3 200 Ohm 4 2 KOhm 5 20 KOhm 6 200KOhm 7   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Range


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    E     Control Name:  Range

 Description:   This parameter gets measurement range


 Variable Type: Integer

 Valid Range:   
                1 = 200 mOhm
                2 = 2    Ohm
                3 = 20   Ohm
                4 = 200  Ohm
                5 = 2   KOhm
                6 = 20  KOhm
                7 = 200 KOhm    K        `    Instrument ID                     |     `    Error                             g w      `    Range                              1    	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    /     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid lower Range
       -3   Invalid upper range
       -4   upper range <= lower range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

         Control Name:  Lower Auto Range

 Description:   This parameter selects the lowest
                range in automatic measurement
                range selection

 Variable Type: Integer

 Valid Range:   1 = 200 mOhm
                2 = 2    Ohm
                3 = 20   Ohm
                4 = 200  Ohm
                5 = 2   KOhm
                6 = 20  KOhm
                7 = 200 KOhm         Control Name:  Upper Auto Range

 Description:   This parameter selects the highest
                range in automatic measurement
                range selection

 Variable Type: Integer

 Valid Range:   1 = 200 mOhm
                2 = 2    Ohm
                3 = 20   Ohm
                4 = 200  Ohm
                5 = 2   KOhm
                6 = 20  KOhm
                7 = 200 KOhm    p        `    Instrument ID                          `    Error                              l           Lower Auto Range                  i l^          Upper Auto Range                   1    	                       C200 mOhm 1 2 Ohm 2 20 Ohm 3 200 Ohm 4 2 KOhm 5 20 KOhm 6 200KOhm 7               C200 mOhm 1 2 Ohm 2 20 Ohm 3 200 Ohm 4 2 KOhm 5 20 KOhm 6 200KOhm 7   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    /     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid lower Range
       -3   Invalid upper range
       -4   upper range <= lower range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

         Control Name:  Lower Auto Range

 Description:   This parameter gets the lowest
                range in automatic measurement
                range selection

 Variable Type: Integer

 Valid Range:   1 = 200 mOhm
                2 = 2    Ohm
                3 = 20   Ohm
                4 = 200  Ohm
                5 = 2   KOhm
                6 = 20  KOhm
                7 = 200 KOhm         Control Name:  Upper Auto Range

 Description:   This parameter gets the highest
                range in automatic measurement
                range selection

 Variable Type: Integer

 Valid Range:   1 = 200 mOhm
                2 = 2    Ohm
                3 = 20   Ohm
                4 = 200  Ohm
                5 = 2   KOhm
                6 = 20  KOhm
                7 = 200 KOhm            `    Instrument ID                          `    Error                              v      `    Lower Auto Range                  z v     `    Upper Auto Range                   1    	            	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid display mode
 -3     Invalid resolution

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
          Control Name:  Display Mode

 Description:   This parameter select the display mode.


 Variable Type: Integer

 Valid Range:   0 = Ohm
                1 = Delta % 
                2 = Comparator

          Control Name:  Display Nominal Value

 Description:   This parameter inputs the nominal value
                from the delta% display mode.


 Variable Type: double


          Control Name:  Resolution

 Description:   This parameter select the resolution 
                of the device.


 Variable Type: Integer

 Valid Range:   0 = 2000 Digits
                1 = 20000 Digits
            `    Instrument ID                     7     `    Error                               R         Display Mode                                Delta Nominal Value                                                          C s         Resolution                         1    	                       Ohm 0 Delta % 1 Comparator 2 ?      A        @4                   Ohm              2000 0 20000 1   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid display mode
 -3     Invalid resolution

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
          Control Name:  Display Mode

 Description:   This parameter select the display mode.


 Variable Type: Integer

 Valid Range:   0 = Ohm
                1 = Delta % 
                2 = Comparator

          Control Name:  Display Nominal Value

 Description:   This parameter inputs the nominal value
                from the delta% display mode.


 Variable Type: double


          Control Name:  Resolution

 Description:   This parameter select the resolution 
                of the device.


 Variable Type: Integer

 Valid Range:   0 = 2000 Digits
                1 = 20000 Digits
            `    Instrument ID                          `    Error                                   `    Display Mode                      p     `    Delta Nominal Value              1                                           " s    `    Resolution                         1    	            	            	           Ohm    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Range Option

 Description:   This parameter activate or
                deactivate the range function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
    @     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid range option
 -3     Invalid current option
 -4     Invalid temperature option
 -5     Invalid sample option
 -6     Invalid trigger option
 -7     Invalid auto/man option
 -8     Invalid load option
 -9     Invalid measure option

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT          Control Name:  Current Option

 Description:   This parameter activate or
                deactivate the current function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Temperature Option

 Description:   This parameter activate or
                deactivate the temperature function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Sample Option

 Description:   This parameter activate or
                deactivate the sample function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Trigger Option

 Description:   This parameter activate or
                deactivate the trigger function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Auto/Man Option

 Description:   This parameter activate or
                deactivate the Auto/Man function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Load Option

 Description:   This parameter activate or
                deactivate the load function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Measure Option

 Description:   This parameter activate or
                deactivate the measure function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
    s        `    Instrument ID                      V /          Range Option                           `    Error                              V           Current Option                     V!          Temperature Option                 V          Sample Option                       .          Trigger Option                                Auto/Man Option                    !          Load Option                                  Measure Option                     1    On 1 Off 0    	            On 1 Off 0    On 1 Off 0    On 1 Off 0    On 1 Off 0    On 1 Off 0    On 1 Off 0    On 1 Off 0   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Range Option

 Description:   This parameter gets the state 
                range function of the
                device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
    @     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid range option
 -3     Invalid current option
 -4     Invalid temperature option
 -5     Invalid sample option
 -6     Invalid trigger option
 -7     Invalid auto/man option
 -8     Invalid load option
 -9     Invalid measure option

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT          Control Name:  Current Option

 Description:   This parameter gets the state 
                of the current function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Temperature Option

 Description:   This parameter gets
                the temperature function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Sample Option

 Description:   This parameter gets the state
                of the sample function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Trigger Option

 Description:   This parameter gets the state
                of the trigger function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Auto/Man Option

 Description:   This parameter gets the state
                of the Auto/Man function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Load Option

 Description:   This parameter gets the state
                of the load function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Measure Option

 Description:   This parameter gets the state
                of the measure function
                on the device display.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
    M        `    Instrument ID                     ~ V      `    Range Option                      i     `    Error                             ñ V      `    Current Option                    ħ V      `    Temperature Option                ŗ V|     `    Sample Option                     Ɗ       `    Trigger Option                           `    Auto/Man Option                   v       `    Load Option                       e |     `    Measure Option                     1    	            	            	            	            	            	            	            	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Display Contrast

 Description:   This parameter is meant for
                adjusting the display contrast.


 Variable Type: Double

 Valid Range:   0.0 - 1.0    i     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid Contrast Value

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
            `    Instrument ID                               Display Contrast                       `    Error                              1 ??              ?                   	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Display Contrast

 Description:   This parameter gets the 
                adjusting of the display contrast.


 Variable Type: Double

 Valid Range:   0.0 - 1.0    i     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid Contrast Value

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
            `    Instrument ID                     F     `    Display Contrast                       `    Error                              1    	           	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Correction State

 Description:   This parameter specifies whether a
                temperature compensation si to be
                carried out during the resistance
                measurement.

 Variable Type: Integer

 Valid Range:   0 = OFF
                1 = ON          Control Name:  Correction Type

 Description:   This parameter specifies whether a
                temperature value in the case of
                temperature compensation should be
                registered automatically or
                entered manually.

 Variable Type: Integer

 Valid Range:   0 = Manualtemperature compensation
                1 = PT100 Auto temperature compensation
                2 = U-Input Auto temperature compensation
                3 = I-Input Auto temperature compensation          Control Name:  Manual Temperature

 Description:   This parameter specifies the
                temperature value in the case of
                temperature compensation should be
                registered manually.

 Variable Type: Double

         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid State
 -3     Invalid Type
 -4     Invalid Reference Temperature
 -5     Invalid Manual Temperature

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT          Control Name:  Manual Temperature

 Description:   This parameter specifies the
                temperature value in the case of
                temperature compensation should be
                registered manually.

 Variable Type: Double

    .        `    Instrument ID                     _ y 6          Compensation State                ه y          Compensation Type                 ۏ y(        Refernce Temperature              ܌     `    Error                            {y                                           Q y        Manual Temperature               |                                            1    On 1 Off 0              %Manual 0 PT100 1 U-Input 2 I-Input 3 ?                  @4                   	            C ?                  @4                   C   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Compensation State

 Description:   This parameter gets the state of the
                temperature compensation.

 Variable Type: Integer

 Valid Range:   0 = OFF
                1 = ON    u     Control Name:  Compensation Type

 Description:   This parameter gets the type 
                temperature compensation.

 Variable Type: Integer

 Valid Range:   0 = Manualtemperature compensation
                1 = PT100 Auto temperature compensation
                2 = U-Input Auto temperature compensation
                3 = I-Input Auto temperature compensation          Control Name:  Manual Temperature

 Description:   This parameter gets the manually
                temperature value


 Variable Type: Double

    t     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid State
 -3     Invalid Type

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT          Control Name:  Manual Temperature

 Description:   This parameter gets the manually
                temperature value


 Variable Type: Double

            `    Instrument ID                      y      `    Compensation State                 y     `    Compensation Type                 . y   `    Manual Temperature                     `    Error                            z                                           E y   `    Reference Temperature            ~s                                            1    	            	            	           	            C    	           C   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Manual Temperature

 Description:   This parameter gets the manually
                temperature value


 Variable Type: Double

    t     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid State
 -3     Invalid Type

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT            `    Instrument ID                      y    `    Temperature Value                      `    Error                            z3                                            1    	           	            C   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  R0

 Description:   Specifies the R0
 Formula :      Rt = R0 *(1 + "a" * t + "b" * t^2 )

 Variable Type: Double

 Default:       0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      330   Invalid Comparator Datas          Control Name:  Coefficient "a"

 Description:   Specifies the coefficient "a".
 Formula :      Rt = R0 *(1 + "a" * t + "b" * t^2 )

 Variable Type: Double

 Default:       0.0          Control Name:  Coefficient "b"

 Description:   Specifies the coefficient "b".
 Formula :      Rt = R0 *(1 + "a" * t + "b" * t^2 )

 Variable Type: Double

 Default:       0.0            `    Instrument ID                     E z j    Z    R0                                     `    Error                              z     Z    Coefficient  "a"                   zS    Z    Coefficient  "b"                                                              1    0.0    	            0.0    0.0    / Formula : Rt = R0 *(1 + "a" * t + "b" * t^2 )   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  R0

 Description:   Gets R0
 Formula :      Rt = R0 *(1 + "a" * t + "b" * t^2 )

 Variable Type: Double

 Default:       0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      330   Invalid Comparator Datas          Control Name:  Coefficient "a"

 Description:   Gets the coefficient "a".
 Formula :      Rt = R0 *(1 + "a" * t + "b" * t^2 )

 Variable Type: Double

 Default:       0.0          Control Name:  Coefficient "b"

 Description:   Gets the coefficient "b".
 Formula :      Rt = R0 *(1 + "a" * t + "b" * t^2 )

 Variable Type: Double

 Default:       0.0            `    Instrument ID                      z j    Z    R0                                     `    Error                              z     Z    Coefficient  "a"                  T zS    Z    Coefficient  "b"                                                              1    	           	            	           	           / Formula : Rt = R0 *(1 + "a" * t + "b" * t^2 )   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  U1/I1

 Description:   Specifies the U1 or I1 value
                for scale t1

 Variable Type: Double

 Default:       0.0

 Valid Range:   0 - 10V  => U-Input (Voltage)
                0 - 20mA => I-Input (Current)    m     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Mode
       -3   Invalid U1 or I1
       -4   Invalid U2 or I2
       -5   Invalid t1
       -6   Invalid t2

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      330   Invalid Comparator Datas          Control Name:  Mode

 Description:   Specifies the scale mode.

 Variable Type: Integer

 Valid Range:   0 = U Input (Voltage)
                1 = I Input (Current)          Control Name:  U2/I2

 Description:   Specifies the U2 or I2 value
                for scale t1

 Variable Type: Double

 Default:       0.0

 Valid Range:   0 - 10V  => U-Input (Voltage)
                0 - 20mA => I-Input (Current)          Control Name:  t1

 Description:   Specifies the t1 value
                for scale of U1 or I1

 Variable Type: Double

 Default:       0.0

 Valid Range:   -200 - 800 C
          Control Name:  t2

 Description:   Specifies the t2 value
                for scale of U2 or I2

 Variable Type: Double

 Default:       0.0

 Valid Range:   -200 - 800 C            `    Instrument ID                     d     Z    U1/I1                                 `    Error                            H d l          Mode                                   Z    U2/I2                             dU    Z    t1                                U    Z    t2                               g                                                                                    g                                                                                      1    0.0    	            I-Input 1 U-Input 0    0.0    0.0    0.0    C    C    V/mA    V/mA   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  U1/I1

 Description:   Gets the U1 or I1 value
                for scale t1

 Variable Type: Double

 Default:       0.0

 Valid Range:   0 - 10V  => U-Input (Voltage)
                0 - 20mA => I-Input (Current)    m     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Mode
       -3   Invalid U1 or I1
       -4   Invalid U2 or I2
       -5   Invalid t1
       -6   Invalid t2

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      330   Invalid Comparator Datas          Control Name:  U2/I2

 Description:   Gets U2 or I2 value
                for scale t1

 Variable Type: Double

 Default:       0.0

 Valid Range:   0 - 10V  => U-Input (Voltage)
                0 - 20mA => I-Input (Current)          Control Name:  t1

 Description:   Gets t1 value
                for scale of U1 or I1

 Variable Type: Double

 Default:       0.0

 Valid Range:   -200 - 800 C
          Control Name:  t2

 Description:   Gets the t2 value
                for scale of U2 or I2

 Variable Type: Double

 Default:       0.0

 Valid Range:   -200 - 800 C          Control Name:  Mode

 Description:   Specifies the scale mode.

 Variable Type: Integer

 Valid Range:   0 = U Input (Voltage)
                1 = I Input (Current)           `    Instrument ID                    
. d     Z    U1/I1                                 `    Error                                  Z    U2/I2                            } dU    Z    t1                               * U    Z    t2                               g                                                                                    g                                                                                     c           Mode                               1    	           	            	           	           	           C    C    V/mA    V/mA    I-Input 1 U-Input 0   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Number of coefficient

 Description:   This parameter selects one of ten
                possible temperature coefficients

 Variable Type: Integer

 Valid Range:   1 to 10          Control Name:  Value of coefficient

 Description:   This parameter specifices the
                value of the desired temperature
                coefficients.The unit is ppm/k.

 Variable Type: Integer

 Valid Range:   -99999 - 99999    f     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid Number of TC

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT   D        `    Instrument ID                    u k           Number of Coeff.                 ; kE         Coeff. Value [ppm/k]             2     `    Error                              1            
   *1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10     ya               	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Number of coefficient

 Description:   This parameter selects one of ten
                possible temperature coefficients

 Variable Type: Integer

 Valid Range:   1 to 10          Control Name:  Value of coefficient

 Description:   This parameter gets the
                value of the desired temperature
                coefficients.The unit is ppm/k.

 Variable Type: Integer

 Valid Range:   -99999 - 99999    f     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid Number of TC

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT           `    Instrument ID                     k           Number of Coeff.                  kE    `    Coeff. Value [ppm/k]                   `    Error                              1            
   *1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10    	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Number of coefficient

 Description:   This parameter selects one of ten
                possible temperature coefficients

 Variable Type: Integer

 Valid Range:   1 to 10    f     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid Number of TC

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT   $U        `    Instrument ID                    % i          Number of Coeff.                 &L     `    Error                              1            
   *1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Value of coefficient

 Description:   This parameter returns the acvtive
                 temperature coefficients

 Variable Type: Integer

    f     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid Number of TC

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT   )        `    Instrument ID                    *       `    Coeff. Value                     +{     `    Error                              1    	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid meaure menu
 -3     Invalid display menu
 -4     Invalid printer menu
 -5     Invalid temp.comp menu
 -6     Invalid contrast menu
 -7     Invalid store config. menu
 -8     Invalid interface menu
 -9     Invalid display state menu
 -10     Invalid aux. input/output menu
 -11     Invalid scale menu
 -12     Invalid datalogger menu
 -13     Invalid calibration menu
 -14     Invalid date menu
 -15     Invalid fast start menu
 -16     Invalid comparator config. menu
 -17     Invalid comparator eval. menu
 -18     Invalid envelope config. menu
 -19     Invalid envelope eval. menu
 -20     Invalid manuall range menu

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
          Control Name:  Measure Menu

 Description:   This parameter activate or
                deactivate the access to the 
                measure menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Display Menu

 Description:   This parameter activate or
                deactivate the access to the 
                display menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Printer Menu

 Description:   This parameter activate or
                deactivate the access to the 
                Printer menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Temp. Comp. Menu

 Description:   This parameter activate or
                deactivate the access to the 
                temperature compensation menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Interface Menu

 Description:   This parameter activate or
                deactivate the access to the 
                interface menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Store Config. Menu

 Description:   This parameter activate or
                deactivate the access to the 
                store config. menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Contrast Menu

 Description:   This parameter activate or
                deactivate the access to the 
                contrast menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Display State Menu

 Description:   This parameter activate or
                deactivate the access to the 
                display state menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Aux. In/Out Menu

 Description:   This parameter activate or
                deactivate the access to the 
                Aux. Input/Output menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Calibration Menu

 Description:   This parameter activate or
                deactivate the access to the 
                Calibration menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Datalogger Menu

 Description:   This parameter activate or
                deactivate the access to the 
                datalogger menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Scale Menu

 Description:   This parameter activate or
                deactivate the access to the 
                scale menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Date Menu

 Description:   This parameter activate or
                deactivate the access to the 
                date menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Fast Start Menu

 Description:   This parameter activate or
                deactivate the access to the 
                fast start menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Comparator Config Menu

 Description:   This parameter activate or
                deactivate the access to the 
                comparator config menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Comparator Eval. Menu

 Description:   This parameter activate or
                deactivate the access to the 
                comparator eval. menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
         Control Name:  Envelope Config. Menu

 Description:   This parameter activate or
                deactivate the access to the 
                envelope config (Envelope Start) menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
         Control Name:  Envelope Eval. Menu

 Description:   This parameter activates or
                deactivates the access to the 
                envelope evalation menu(Reset Button).
                

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Manual Range Menu

 Description:   This parameter activate or
                deactivate the access to the 
                manual range menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
   .        `    Instrument ID                    /$    `    Error                            4            Measure Menu                     5           Display Menu                     6} w          Printer Menu                     7j           Temp.Comp. Menu                  8l _          Interface Menu                   9] _           Store Config. Menu               :V _ )          Contrast Menu                    ;E _w          Display State Menu               <> _ 	         Aux. In/Out Menu                 =9           Calibration Menu                 >.            Datalogger Menu                  ?!  ) 
         Scale Menu                       @
 v 
         Date Menu                        @           Fast Start Menu                  A  )          Compara. Conf. Menu              B            Compara. Eval. Menu              C           Envelope Conf. Menu              D w          Envelope Eval. Menu              F           Man.Range Menu                     1    	           On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0    On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   On 1 Off 0   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid meaure menu
 -3     Invalid display menu
 -4     Invalid printer menu
 -5     Invalid temp.comp menu
 -6     Invalid contrast menu
 -7     Invalid store config. menu
 -8     Invalid interface menu
 -9     Invalid display state menu
 -10     Invalid aux. input/output menu
 -11     Invalid scale menu
 -12     Invalid datalogger menu
 -13     Invalid calibration menu
 -14     Invalid date menu
 -15     Invalid fast start menu
 -16     Invalid comparator config. menu
 -17     Invalid comparator eval. menu
 -18     Invalid envelope config. menu
 -19     Invalid envelope eval. menu
 -20     Invalid manuall range menu

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
          Control Name:  Measure Menu

 Description:   This parameter gets the state of
                measure menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Display Menu

 Description:   This parameter gets the state of the
                display menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Printer Menu

 Description:   This parameter gets the state of the
                Printer menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Temp. Comp. Menu

 Description:   This parameter gets the state of the
                temperature compensation menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Interface Menu

 Description:   This parameter gets the state of the 
                interface menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Store Config. Menu

 Description:   This parameter gets the state of the
                store config. menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Contrast Menu

 Description:   This parameter gets the state of the
                contrast menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Display State Menu

 Description:   This parameter gets the state of the
                display state menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Aux. In/Out Menu

 Description:   This parameter gets the state of the
                Aux. Input/Output menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Calibration Menu

 Description:   This parameter gets the state of the
                Calibration menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Datalogger Menu

 Description:   This parameter gets the state of the
                datalogger menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Scale Menu

 Description:   This parameter gets the state of the
                scale menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Date Menu

 Description:   This parameter gets the state of the
                date menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Fast Start Menu

 Description:   This parameter gets the state of the
                fast start menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Comparator Config Menu

 Description:   This parameter gets the state of the
                comparator config menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Comparator Eval. Menu

 Description:   This parameter gets the state of the
                comparator eval. menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Envelope Config. Menu

 Description:   This parameter gets the state of the
                envelope config (Envelope Start) menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Envelope Eval. Menu

 Description:   This parameter gets the state of the 
                envelope evalation menu(Reset Button).
                

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
          Control Name:  Manual Range Menu

 Description:   This parameter gets the state of the
                manual range menu.

 Variable Type: Integer

 Valid Range:   0 = OFF  
                1 = ON   
   L~        `    Instrument ID                    M$    `    Error                            R|  z     `    Measure Menu                     SA       `    Display Menu                     T
 Y     `    Printer Menu                     T      `    Temp.Comp. Menu                  U _      `    Interface Menu                   V _ z     `    Store Config. Menu               WT _      `    Contrast Menu                    X _Y     `    Display State Menu               X _ 	    `    Aux. In/Out Menu                 Y       `    Calibration Menu                 Z  {     `    Datalogger Menu                  [k   
    `    Scale Menu                       \0 X 
    `    Date Menu                        \      `    Fast Start Menu                  ]       `    Compara. Conf. Menu              ^  {     `    Compara. Eval. Menu              _z       `    Envelope Conf. Menu              `e Y     `    Envelope Eval. Menu              a`      `    Man.Range Menu                     1    	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Printer State

 Description:   If the printer started or stopped


 Variable Type: Integer

 Valid Range:   0 = Stop
                1 = Start         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State
       -3   Invalid relais mode
       -4   Invalid on error

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   g        `    Instrument ID                    h |	          Printer State                    iZ     `    Error                              1    Start 1 Stop 0    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Print Temperature

 Description:   Switch the print temperature function
                ON or OFF.

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On    3     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Print Temperature
       -3   Invalid Print Counter
       -4   Invalid Print Label
       -5   Invalid Print Time
       -6   Invalid Print Date
       -7   Invalid Meas.Values/Header
       -8   Invalid Label Text (to long)
       -9   Invalid Timer Interval HH
       -10   Invalid Timer Interval MM
       -11   Invalid Timer Interval SS


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Print Counter

 Description:   Switch the print counter function
                ON or OFF

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On          Control Name:  Print Label

 Description:   Switch the print label function
                ON or OFF

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On          Control Name:  Print Time

 Description:   Switch the print time function
                ON or OFF

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On          Control Name:  Print Date

 Description:   Switch the print date function
                ON or OFF

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On          Control Name:  Meas.Values/Header

 Description:   Specifices how many measure values
                do want print per header.

 Variable Type: Integer

 Valid Range:   1 - 1000
          Control Name:  Label text

 Description:   Specifices the label text for the
                printer.

 Variable Type: String

 Valid Range:   max. 10 Byte
          Control Name:  Timer Interval HH

 Description:   Specifices the hours for the timer
                interval.

 Variable Type: Integer

 Valid Range:   0 -99
          Control Name:  Timer Interval MM

 Description:   Specifices the minutes for the timer
                interval.

 Variable Type: Integer

 Valid Range:   0 -59
          Control Name:  Timer Interval SS

 Description:   Specifices the seconds for the timer
                interval.

 Variable Type: Integer

 Valid Range:   0 - 59
   mC        `    Instrument ID                    nt f 2          Print Temperature                o:     `    Error                            su f           Print Counter                    t2 f           Print Label                      t f?          Print Time                       u f          Print Date                       vY           Meas.Values/Header               w      `    Label Text                       w F        HH                               xh j 	       MM                               y  
       SS                               `                                                                                    U                                                                                       1    On 1 Off 0    	            On 1 Off 0    On 1 Off 0    On 1 Off 0    On 1 Off 0                       Header Text    0    0    0    :    :    Timer Interval    (max. Length 10 Byte)   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Print Temperature

 Description:   Switch the print temperature function
                ON or OFF.

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On    3     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Print Temperature
       -3   Invalid Print Counter
       -4   Invalid Print Label
       -5   Invalid Print Time
       -6   Invalid Print Date
       -7   Invalid Meas.Values/Header
       -8   Invalid Label Text (to long)
       -9   Invalid Timer Interval HH
       -10   Invalid Timer Interval MM
       -11   Invalid Timer Interval SS


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Print Counter

 Description:   Switch the print counter function
                ON or OFF

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On          Control Name:  Print Label

 Description:   Switch the print label function
                ON or OFF

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On          Control Name:  Print Time

 Description:   Switch the print time function
                ON or OFF

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On          Control Name:  Print Date

 Description:   Switch the print date function
                ON or OFF

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On          Control Name:  Meas.Values/Header

 Description:   Specifices how many measure values
                do want print per header.

 Variable Type: Integer

 Valid Range:   1 - 1000
          Control Name:  Label text

 Description:   Specifices the label text for the
                printer.

 Variable Type: String

 Valid Range:   max. 10 Byte
          Control Name:  Timer Interval HH

 Description:   Specifices the hours for the timer
                interval.

 Variable Type: Integer

 Valid Range:   0 -99
          Control Name:  Timer Interval MM

 Description:   Specifices the minutes for the timer
                interval.

 Variable Type: Integer

 Valid Range:   0 -59
          Control Name:  Timer Interval SS

 Description:   Specifices the seconds for the timer
                interval.

 Variable Type: Integer

 Valid Range:   0 - 59
   }        `    Instrument ID                     f      `    Print Temperature                     `    Error                             f {     `    Print Counter                     f      `    Print Label                      z fI     `    Print Time                       1 f     `    Print Date                             `    Meas.Values/Header                 }    `    Label Text                       M          HH                                	 	       MM                                ) 
       SS                                                                          "                                                                                       1    	            	            	            	            	            	            	            	            	            	            	            :    :    Timer Interval   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
   
  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

           `    Instrument ID                    A     `    Error                              1    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State
       -3   Memory label to long

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Memory No.State

 Description:   Specificies the memory No. to 
                store the the label text

 Variable Type: Integer

 Valid Range:   0 -  32
          Control Name:  Memory Label

 Description:   Specifices the memory label.

 Variable Type: String

 Valid Range:   max. 10 Byte
           `    Instrument ID                         `    Error                             t          Memory No.                        t-    `    Memory Label                     -                                                                                       1    	                                       (max. Length 10 Byte)    (No 32 = Default)   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Memory No.State

 Description:   Specificies the memory No. to 
                store the the label text

 Variable Type: Integer

 Valid Range:   0 -  32
     t     Control Name:  Memory Label

 Description:   Return the memory label.

 Variable Type: String (10 Byte + NULL)


           `    Instrument ID                         `    Error                             t          Memory No.                       s t-    `    Memory Label                                                                  1    	                                   	            (No 32 = Default)   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Memory No.

 Description:    Specifies the Memory No.

 Variable Type:  integer

 Valid Range:    0 to 32

 Default:        0
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Memory No.

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty   A        `    Instrument ID                    r      2    Memory No.                            `    Error                                                                         1                           	            (No 32 = Default)   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Memory No.

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty          Control Name:   Memory No.

 Description:    Specifies the Memory No.

 Variable Type:  integer

 Valid Range:    0 to 32

 Default:        0
   )        `    Instrument ID                    Z     `    Error                                                                       g t     2    Memory No.                         1    	            (No 32 = Default)                          )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    I     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT           `    Instrument ID                    B     `    Error                              1    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.     D     The control return the measurement value

 Variable Type : double     R     The control return the measurement unit

 Variable Type : String (Length=8Byte)         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT => No Value available
 302   There ist's no measurement started
 303   Timeout for wait of RQS Byte
 304   GPIB Error for read the RQS Byte

 System Device Errors : 
----------------------------------------------
 310   Temperature Compensation Error
 311   U-Cable Error
 312   I-Oszillation Error 
 313   Under Load Error 
 314   Over Load Error 
 315   I-Over Error 
 316   Meas.Amplifier U-Overrange Error 
 317   Meas.Amplifier I-Overrange Error 

           `    Instrument ID                    ?      `    Measured Value                    $    `    Unit                                  `    Error                              1    	           	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.     D     The control return the measurement value

 Variable Type : double         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT => No Value available
 302   There ist's no measurement started
 303   Timeout for wait of RQS Byte
 304   GPIB Error for read the RQS Byte

 System Device Errors : 
----------------------------------------------
 310   Temperature Compensation Error
 311   U-Cable Error
 312   I-Oszillation Error 
 313   Under Load Error 
 314   Over Load Error 
 315   I-Over Error 
 316   Meas.Amplifier U-Overrange Error 
 317   Meas.Amplifier I-Overrange Error 

 
           `    Instrument ID                    *      `    Measured Value                   v     `    Error                              1    	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    I     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT   K        `    Instrument ID                    |     `    Error                              1    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the comparator
                is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State
       -3   Invalid relais mode
       -4   Invalid on error

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Relais Mode

 Description:   If the relais mode is On, the 
                comparator relais are active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On          Control Name:  On Error

 Description:   If the On Error is upper,the 
                comparator show the ">" - token
                by an error

 Variable Type: Integer

 Valid Range:   0 = None
                1 = Upper ">"-token   H        `    Instrument ID                    y |           State                            .     `    Error                            U |           Relais Mode                        |[          On Error                           1    On 1 Off 0    	            On 1 Off 0    ">" Token 1 None 0   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   Gets the state is On the comparator


 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State
       -3   Invalid relais mode
       -4   Invalid on error

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Relais Mode

 Description:   Gets the relais mode 


 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On          Control Name:  On Error

 Description:   Gets the On Error is upper,the 
                comparator show the ">" - token
                by an error

 Variable Type: Integer

 Valid Range:   0 = None
                1 = Upper ">"-token   `        `    Instrument ID                    ʑ | |     `    State                            /     `    Error                            V |      `    Relais Mode                       |[     `    On Error                           1    	            	            	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Lower Limit

 Description:   Specifies the lower limit of the
                two limit comparator

 Variable Type: Double

 Default:       0.0          Control Name:  Upper Limit

 Description:   Specifies the upper limit of the
                two limit comparator

 Variable Type: Double

 Default:       0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      330   Invalid Comparator Datas            `    Instrument ID                    Q m     `    Lower Limit                       mG    `    Upper Limit                      ӣ     `    Error                              1    0.0    0.0    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Lower Limit

 Description:   Gets the lower limit of the
                two limit comparator

 Variable Type: Double

 Default:       0.0          Control Name:  Upper Limit

 Description:   Gets Specifies the upper limit of the
                two limit comparator

 Variable Type: Double

 Default:       0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      330   Invalid Comparator Datas   ׋        `    Instrument ID                    ؼ m     `    Lower Limit                      ` mG    `    Upper Limit                           `    Error                              1    	           	           	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Limit 1

 Description:   Specifies the limit 1 of the
                four limit comparator 

 Variable Type: Double

 Default:       0.0          Control Name:  Limit2

 Description:   Specifies the limit 2 of the
                four limit comparator 

 Variable Type: Double

 Default:       0.0          Control Name:  Limit 3

 Description:   Specifies the limit 3 of the
                four limit comparator 

 Variable Type: Double

 Default:       0.0          Control Name:  Limit4

 Description:   Specifies the limit 4 of the
                four limit comparator 

 Variable Type: Double

 Default:       0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      330   Invalid Comparator Datas            `    Instrument ID                    1      `    Limit1                                `    Limit2                           v m     `    Limit3                            m    `    Limit4                                `    Error                              1    0.0    0.0    0.0    0.0    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Limit 1

 Description:   Gets the limit 1 of the
                four limit comparator 

 Variable Type: Double

 Default:       0.0          Control Name:  Limit2

 Description:   Gets the limit 2 of the
                four limit comparator 

 Variable Type: Double

 Default:       0.0          Control Name:  Limit 3

 Description:   Gets the limit 3 of the
                four limit comparator 

 Variable Type: Double

 Default:       0.0          Control Name:  Limit4

 Description:   Gets the limit 4 of the
                four limit comparator 

 Variable Type: Double

 Default:       0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      330   Invalid Comparator Datas           `    Instrument ID                    L      `    Limit1                                `    Limit2                            m     `    Limit3                           % m    `    Limit4                                `    Error                              1    	           	           	           	           	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Value 1

 Description:   Value 1 returns the Numbers of values
                are smaller than lower limit.

 Variable Type: Integer         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Temperature Error
      313   Device Calibration Error
      314   Device In Over Error
      315   Device Out Over Error
      316   Device Lowbat Error          Control Name:  Value 2

 Description:   Value 2 returns the Numbers of values
                are greather than lower limit and smaller 
                than upper limit.

 Variable Type: Integer          Control Name:  Value 3

 Description:   Value 3 returns the Numbers of values
                are greather than upper limit.

 Variable Type: Integer   6        `    Instrument ID                    g z e     `    Value1                                `    Error                             y      `    Value2                            yX     `    Value3                             1    	            	            	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Temperature Error
      313   Device Calibration Error
      314   Device In Over Error
      315   Device Out Over Error
      316   Device Lowbat Error          Control Name:  Value 1

 Description:   Value 1 returns the Numbers of values
                are smaller than limit1.

 Variable Type: Integer          Control Name:  Value 2

 Description:   Value 2 returns the Numbers of values
                are greather than limit1 and smaller 
                than limit2.

 Variable Type: Integer          Control Name:  Value 5

 Description:   Value 5 returns the Numbers of values
                are greather than limit4.

 Variable Type: Integer          Control Name:  Value 3

 Description:   Value 3 returns the Numbers of values
                are greather than limit3 and smaller 
                than limit3.

 Variable Type: Integer          Control Name:  Value 4

 Description:   Value 4 returns the Numbers of values
                are greather than limit3 and smaller 
                than limit4.

 Variable Type: Integer   o        `    Instrument ID                         `    Error                            ] {      `    Value1                            { ~     `    Value2                            {     `    Value5                           V {      `    Value3                            {R     `    Value4                             1    	            	            	            	            	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

            `    Instrument ID                         `    Error                              1    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the envelope
                acquistition is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

           `    Instrument ID                    L m          State                                 `    Error                              1    On 1 Off 0    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   Getsthe State is On the envelope
                acquistition 

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   
        `    Instrument ID                     m     `    State                                 `    Error                              1    	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Min. Value

 Description:   Returns the minimum envelope
                Value of the instrument.

 Variable Type: string          Control Name:  Max. Value

 Description:   Returns the maximum envelope
                Value of the instrument.

 Variable Type: string          Control Name:  Diff. Value

 Description:   Returns the difference envelope
                Value of the instrument.

 Variable Type: string         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Temperature Error
      313   Device Calibration Error
      314   Device In Over Error
      315   Device Out Over Error
      316   Device Lowbat Error   C        `    Instrument ID                    t } n    `    Min. Value                        }     `    Max. Value                        }    `    Diff. Value                      1     `    Error                              1    	            	            	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   ,        `    Instrument ID                    ]     `    Error                              1    	            H     Panel Name:    Tare State

 Description:   Sets the Tare State ON/OFF    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   Switch the datalogger state is On or Off.


 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

           `    Instrument ID                    * j          Datenlogger State                     `    Error                              1    On 1 Off 0    	            H     Panel Name:    Tare State

 Description:   Sets the Tare State ON/OFF    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   Gets the datalogger state


 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   "        `    Instrument ID                    # j     `    Datenlogger State                $     `    Error                              1    	            	            T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Block No.
       -3   Invalid Block size
       -4   Block name to long
       -5   Invalid Filter
       -6   Invalid X-Value
       -7   Invalid hours
       -8   Invalid minutes
       -9   Invalid secondes
       -10  Invalid Delta

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Block No.

 Description:   Specificies the block no., do you 
                want to configure


 Variable Type: Integer

 Valid Range:   0 - 31
          Control Name:  Block Name

 Description:   Specificies the name of the block.
 

 Variable Type: String (max. Length 10 Byte)


   (        `    Instrument ID                    )    `    Error                            - k          Block No.                        .: m
    `    Name                               1    	                                      T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Block No.
       -3   Invalid Block size
       -4   Block name to long
       -5   Invalid Filter
       -6   Invalid X-Value
       -7   Invalid hours
       -8   Invalid minutes
       -9   Invalid secondes
       -10  Invalid Delta

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Block No.

 Description:   Specificies the block no., do you 
                want to configure


 Variable Type: Integer

 Valid Range:   0 - 31
          Control Name:  Block Name

 Description:   Specificies the name of the block.
 

 Variable Type: String (max. Length 10 Byte)


   0!        `    Instrument ID                    1R    `    Error                            5" l          Block No.                        5 m
    `    Name                               1    	                                  	            T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Block No.
       -3   Invalid Block size
       -4   Block name to long
       -5   Invalid Filter
       -6   Invalid X-Value
       -7   Invalid hours
       -8   Invalid minutes
       -9   Invalid secondes
       -10  Invalid Delta

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    F     Control Name:  Block Size

 Description:   Specificies the size of the block.
                The hole memory size of the device
                if 20000. If define one block with
                20000, you have no memory free to 
                define another block.
 

 Variable Type: Integer

 Valid Range:   0 - 20000
          Control Name:  Block No.

 Description:   Specificies the block no., do you 
                want to configure


 Variable Type: Integer

 Valid Range:   0 - 31
   7        `    Instrument ID                    8    `    Error                            < ~)         Block Size                       >           Block No.                          1    	              N                                          T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Block No.
       -3   Invalid Block size
       -4   Block name to long
       -5   Invalid Filter
       -6   Invalid X-Value
       -7   Invalid hours
       -8   Invalid minutes
       -9   Invalid secondes
       -10  Invalid Delta

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    ?     Control Name:  Block Size

 Description:   Gets the size of the block.
                The hole memory size of the device
                if 20000. If define one block with
                20000, you have no memory free to 
                define another block.
 

 Variable Type: Integer

 Valid Range:   0 - 20000
          Control Name:  Block No.

 Description:   Specificies the block no., do you 
                want to configure


 Variable Type: Integer

 Valid Range:   0 - 31
   @'        `    Instrument ID                    AX    `    Error                            E( j    `    Block Size                       Fo k          Block No.                          1    	            	                                  T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Block No.
       -3   Invalid Block size
       -4   Block name to long
       -5   Invalid Filter
       -6   Invalid X-Value
       -7   Invalid hours
       -8   Invalid minutes
       -9   Invalid secondes
       -10  Invalid Delta

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Block No.

 Description:   Specificies the block no., do you 
                want to configure


 Variable Type: Integer

 Valid Range:   0 - 31
         Control Name:  Filter

 Description:   Specificies the filter of the block.
 

 Variable Type: Integer

 Valid Range:   0 = All values are logged
                1 = Only good values are logged              
                2 = Only bad values are logged
                3 = Only the x-values values are logged
                4 = Timer inteval for logging
                5 = The value will be logged, if
                    the difference to the previous
                    value is greather than then
                    delta value.          Control Name:  X-Value

 Description:   The X-value defines the interval
                in witch the value is regularly 
                stored.


 Variable Type: Integer

 Valid Range:   2 - 9999
    P     Control Name:  Delta Value

 Description:   Specificies the delta value of the 
                block.

 Note :         The value will be logged, if
                the difference to the previous
                value is greather than then
                delta value. 
 

 Variable Type: double

 Valid Range:   0.01mOhm - 200 KOhm
          Control Name:  Time HH

 Description:   Specifices the hours for the time.


 Variable Type: Integer

 Valid Range:   0 -99
          Control Name:  Timer Interval MM

 Description:   Specifices the minutes for the time.


 Variable Type: Integer

 Valid Range:   0 -59
          Control Name:  Timer Interval SS

 Description:   Specifices the seconds for the time.


 Variable Type: Integer

 Valid Range:   0 - 59
   H        `    Instrument ID                    I    `    Error                            M k          Block No.                        N,  _         Filter                           PP           XValue                           Q!    `    Delta                            Ry         HH                               S  5        MM                               S U        SS                               +                                          N                                          4                                                                                      1    	                                             5All 0 No Failure 1 Failure 2 XValue 3 Time 4 Delta 5      '                 0.0    0    0    0    :    :    Time    Ohm    T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Block No.
       -3   Invalid Block size
       -4   Block name to long
       -5   Invalid Filter
       -6   Invalid X-Value
       -7   Invalid hours
       -8   Invalid minutes
       -9   Invalid secondes
       -10  Invalid Delta

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Block No.

 Description:   Specificies the block no., do you 
                want to configure


 Variable Type: Integer

 Valid Range:   0 - 31
         Control Name:  Filter

 Description:   Gets the filter of the block.
 

 Variable Type: Integer

 Valid Range:   0 = All values are logged
                1 = Only good values are logged              
                2 = Only bad values are logged
                3 = Only the x-values values are logged
                4 = Timer inteval for logging
                5 = The value will be logged, if
                    the difference to the previous
                    value is greather than then
                    delta value.          Control Name:  X-Value

 Description:   Gets the X-value .The interval
                in witch the value is regularly 
                stored.


 Variable Type: Integer

 Valid Range:   2 - 9999
    I     Control Name:  Delta Value

 Description:   Gets the delta value of the 
                block.

 Note :         The value will be logged, if
                the difference to the previous
                value is greather than then
                delta value. 
 

 Variable Type: double

 Valid Range:   0.01mOhm - 200 KOhm
     y     Control Name:  Time HH

 Description:   Gets the hours for the time.


 Variable Type: Integer

 Valid Range:   0 -99
          Control Name:  Timer Interval MM

 Description:   Gets the minutes for the time.


 Variable Type: Integer

 Valid Range:   0 -59
          Control Name:  Timer Interval SS

 Description:   Gets the seconds for the time.


 Variable Type: Integer

 Valid Range:   0 - 59
   W        `    Instrument ID                    Y    `    Error                            \ k          Block No.                        ]      `    Filter                           _      `    XValue                           `    `    Delta                            a         HH                               bQ 5        MM                               b U        SS                               +                                          N                                          4                                                                                      1    	                                  	            	            	           	            	            	            :    :    Time    Ohm    T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Block No.

 Description:   Specificies the block no., do you 
                want to clear


 Variable Type: Integer

 Valid Range:   0 - 31
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   g        `    Instrument ID                    h3 ~          Block                            h     `    Error                              1                          	            T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Select Mode

 Description:   Switch the selecte mode, do you 
                want to set the active block


 Variable Type: Integer

 Valid Range:   0 = Set active by block no.
                1 = Set active by block name
          Control Name:  Block Name

 Description:   Specificies the name of the block.
 

 Variable Type: String (max. Length 10 Byte)


          Control Name:  Block No.

 Description:   Specificies the block no., do you 
                want to set as active block.


 Variable Type: Integer

 Valid Range:   0 - 31
   l        `    Instrument ID                    n     `    Error                            q >           Select Mode                      q $    `    Name                             r           Block No.                          1    	            By Name 1 By Block No. 0                              T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

     |     Control Name:  Block No.

 Description:   Returns the active block no.


 Variable Type: Integer

 Valid Range:   0 - 31
   t        `    Instrument ID                    v     `    Error                            y      `    Block No.                          1    	            	            T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Count

 Description:   Returns the numbers of counts from
                the block.

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Block No.

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Block No.

 Description:   Specificies the block no., do you 
                want to clear


 Variable Type: Integer

 Valid Range:   0 - 31
   z        `    Instrument_ID                    { z8     `    Count                            |     `    Error                            x z          Block No.                          1    	            	                                  T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Block No.

 Description:   Specificies the block no., do you 
                want to read


 Variable Type: Integer

 Valid Range:   0 - 31
          Control Name:  Start Number

 Description:   Specificies the start number from to you
                want to read 20 Values


 Variable Type: Integer

 Valid Range:   1 - 20000
     i     Control Name:  Values

 Description:   return the meas.values of the block.


 Variable Type: String

     `     Control Name:  Date

 Description:   return the date of the block.


 Variable Type: String

     `     Control Name:  Time

 Description:   return the time of the block.


 Variable Type: String

           `    Instrument ID                         `    Error                             c k         Block No.                        F c          Start Number                       k    `    Value                            t      `    Date                              K    `    Time                               1    	                                                   	            	            	            T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.     k     Control Name:  Minimum

 Description:   Return the minimum value of the block.


 Variable Type: String
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Block No

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

     r     Control Name:  Std. Deviation

 Description:   Return the Std.deviation of the block.


 Variable Type: String
     k     Control Name:  Maximum

 Description:   Return the maximum value of the block.


 Variable Type: String
     k     Control Name:  Mean value

 Description:   Return the mean value of the block.


 Variable Type: String
          Control Name:  Block No.

 Description:   Specificies the block no., do you 
                want to read


 Variable Type: Integer

 Valid Range:   0 - 31
   v "       `    Instrument ID                     [     `    Minimum                              `    Error                             W    `    Std. Deviation                    [V    `    Maximum                                `    Mean Value                       g [ !         Block No.                          1    	            	            	            	            	                                 )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Bit 0

 Description:   With this parameter can be set or
                reset the Bit 0 of I/O register.

 Variable Type: Integer

 Valid Range:   0  = OFF
                1  = ON         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid Bit 2 value
 -3     Invalid Bit 1 value
 -4     Invalid Bit 0 value

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
          Control Name:  Bit 1

 Description:   With this parameter can be set or
                reset the Bit 1 of I/O register.

 Variable Type: Integer

 Valid Range:   0  = OFF
                1  = ON          Control Name:  Bit 2

 Description:   With this parameter can be set or
                reset the Bit 2 of I/O register.

 Variable Type: Integer

 Valid Range:   0  = OFF
                1  = ON           `    Instrument ID                    
 ve          Bit 0                                 `    Error                            ~ v           Bit 1                            L v           Bit 2                              1    On 1 Off 0    	            On 1 Off 0    On 1 Off 0   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid Pin 3  Value
 -3     Invalid Pin 21  Value

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
          Control Name:  Bit 2

 Description:   Return the value of Bit 2 from 
                I/O register.

 Variable Type: Integer

          Control Name:  Bit 3

 Description:   Return the value of Bit 3 from 
                I/O register.

 Variable Type: Integer

     |     Control Name:  Bit 1

 Description:   Return the value of 1 from
                I/O register.

 Variable Type: Integer

          Control Name:  Bit 0

 Description:   Return the value of Bit 0 
                from I/O register.

 Variable Type: Integer

   ^        `    Instrument ID                         `    Error                                   `    Bit 2                                   `    Bit 3                            .       `    Bit 1                             q     `    Bit 0                              1    	            	            	            	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0     Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT
          Control Name:  System Timer HH

 Description:   Specifices the hours for the time


 Variable Type: Integer

 Valid Range:   0 - 23
          Control Name:  System Time MM

 Description:   Specifices the minutes for the timer


 Variable Type: Integer

 Valid Range:   0 -59
          Control Name:  System Time SS

 Description:   Specifices the seconds for the timer


 Variable Type: Integer

 Valid Range:   0 - 59
          Control Name:  System Date (Day)

 Description:   Specifices the day for the system 
                date.

 Variable Type: Integer

 Valid Range:   0 - 31
          Control Name:  System Date (Month)

 Description:   Specifices the month for the system
                date.

 Variable Type: Integer

 Valid Range:   1 - 12
          Control Name:  System Date (Year) YYYY

 Description:   Specifices the year (YYYY) for the
                system date .

 Variable Type: Integer


           `    Instrument ID                         `    Error                            u          HH                                         MM                                         SS                                                                                                                     c                                           %         Day                               6        Month                            v V    (    Year                             ,                                          O                                          c!                                          X                                            1    	            0    0    0    :    :    System Time    1    1    1997    .    .    System Date    (YYYY)   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0     Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT
           `    Instrument ID                         `    Error                              1    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Keyboard

 Description:   This parameter locks the keyboard
                on the front panel of the
                instrument

 Variable Type: Integer

 Valid Range:   0  = Unlocked
                1  = Locked         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Value

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

           `    Instrument ID                     m           Keyboard                              `    Error                              1    Locked 1 Unlocked 0    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the calibration
                mode is active

 Variable Type: Integer

 Valid Range:   0  = OFF
                1  = ON    a     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid State


 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
   ]        `    Instrument ID                               State                            K     `    Error                              1    On 1 Off 0    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    a     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid range


 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
    "     Control Name:  Range

 Description:   Select the range to calibrate

 Variable Type: Integer

 Valid Range:   0  = 200mOhm
                1  = 2Ohm
                2  = 20Ohm
                3  = 200Ohm
                4  = 2KOhm
                5  = 20KOhm
                6  = 200KOhm          Control Name:  Value

 Description:   Input the calibration value for 
                the selected range

 Variable Type: double

 Valid Range:   200mOhm - 200 KOHm
   r        `    Instrument ID                         `    Error                             f          Range                            6 f!        Value                              1    	                       G200 mOhm 0 2  Ohm 1 20  Ohm 2 200  Ohm 3 2 KOhm 4 20 KOhm 5 200 KOhm 6 ?                                      )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    `     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid mode


 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
          Control Name:  Mode

 Description:   Select the 20mV calibration mode


 Variable Type: Integer

 Valid Range:   0  = LOW
                1  = High   M        `    Instrument ID                    ~     `    Error                                       Mode                               1    	          
  High 1 Low 0   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    L     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
   D        `    Instrument ID                    u     `    Error                              1    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    K     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID


 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
     w     Control Name:  Resistance Value (ca. 200mOhm)

 Description:   Input the resistance value


 Variable Type: double

          Control Name:  Low Voltage

 Description:   Input the low voltage value from
                the cal_20mV_init measure before.


 Variable Type: double

          Control Name:  High Voltage

 Description:   Input the high voltage value from
                the cal_20mV_init measure before.


 Variable Type: double

   D  *      `    Instrument ID                    u     `    Error                              L        Resistance Value (ca. 200 mOhm)  G          Low Voltage                       r        High Voltage                       1    	         ?                                    ?                                    ?                                      )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    `     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid Mode


 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
          Control Name:  Mode

 Description:   Select the voltage calibration mode


 Variable Type: Integer

 Valid Range:   0  = LOW
                1  = High   ,        `    Instrument ID                    ]     `    Error                                       Mode                               1    	          
  High 1 Low 0   )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    J     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
          Control Name:  Low Voltage

 Description:   Input the low voltage value from
                the cal_volatge_mode measure before.


 Variable Type: double
          Control Name:  High Voltage

 Description:   Input the high voltage value from
                the cal_volatge_mode measure before.


 Variable Type: double
   &        `    Instrument ID                    W     `    Error                            ک          Low Voltage                      O )        High Voltage                       1    	         ?                                    ?                                      )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    K     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 
 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
     q     Control Name:  Current Value

 Description:   Input the current value to calibrate.



 Variable Type: double
   2        `    Instrument ID                    c     `    Error                                      Current Value                      1    	         ?                                      )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    `     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID
 -2     Invalid mode


 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
          Control Name:  Mode

 Description:   Select the PT100 calibration mode


 Variable Type: Integer

 Valid Range:   0  = LOW
                1  = High          Control Name:  Value

 Description:   Input the PT100 calibration value.


 Variable Type: Integer

 Valid Range:   LOW-Mode = ca 50 Ohm
                High-Mode = ca. 200 Ohm   
        `    Instrument ID                    ;     `    Error                             ~           Mode                             B         Value                              1    	          
  High 1 Low 0 ?                                      )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    K     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID


 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT
           `    Instrument ID                    N     `    Error                              1    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Send SCPI-Message

 Description:   This control is a string parameter
                You must input the SCPI-message
                without the LineFeed termination.

 Example      : ":SENS:CORR:STATE ON"

 Variable Type: String
    M     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID


 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT


           `    Instrument ID                    M      `    Send-SCPI-Message                N     `    Error                              1        	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Send SCPI-Message

 Description:   This control is a string parameter
                You must input Query-Form from
                the SCPI-message without the
                LineFeed termination.

 Example      : ":SENS:CORR:STATE?"

 Variable Type: String          Control Name:  Answer from Slave

 Description:   This control return a string from
                the slave.

 Variable Type: String (Lenght => see the 2304
                        Manual SCPI-Commands)    M     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID


 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT


   W        `    Instrument ID                          `    Send-SCPI-Message                 $    `    Answer from Slave                }     `    Error                              1        	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    M     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID


 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator

 300   The instrument sends NAK
 301   The instrument sends EOT


           `    Instrument ID                         `    Error                              1    	                    Q&     K.    init_gpib                         
=         ]     K.    init_serial                                cI     K.    local_gpib                        Y         p, 	    K.    set_config_meas                   <          	    K.    get_config_meas                            B     K.    set_config_range                                K.    get_config_range                                K.    set_config_auto_range             !         	     K.    get_config_auto_range                           K.    set_config_display_mode                         K.    get_config_display_mode           z          
    K.    set_config_display_options                 Z 
    K.    get_config_display_options        w         :     K.    set_config_display_contrast                r     K.    get_config_display_contrast                N     K.    set_config_temp_compensation                    K.    get_config_temp_compensation      ;              K.    get_temp_value                             M     K.    set_config_scale_pt100            e         	     K.    get_config_scale_pt100                    	V     K.    set_config_scale_ui_input                      K.    get_config_scale_ui_input          C             K.    set_config_temp_coefficient                #+     K.    get_config_temp_coefficient       ![        (     K.    set_active_temp_coefficient       !        -     K.    get_active_temp_coefficient       "l        G
     K.    set_config_device_access          "        b3     K.    get_config_device_access          $        l     K.    set_config_printer_state          $u        y     K.    set_config_printer_mode           $        P     K.    get_config_printer_mode           %7             K.    printer_counter_reset             &)             K.    set_config_memory_label           &             K.    get_config_memory_label           '-             K.    set_config_memory                 '              K.    get_config_memory                 )             K.    meas_start                        *             K.    meas_read                         *             K.    meas_read_string                  *             K.    meas_stop                         +             K.    set_config_comparator_mode        ,             K.    get_config_comparator_mode        -        ֘     K.    set_config_2_limit_comparator     .             K.    get_config_2_limit_comparator     .             K.    set_config_4_limit_comparator     /             K.    get_config_4_limit_comparator     /        1     K.    comparator_2_limit_report         0             G.    comparator_4_limit_report         2)             K.    comparator_clear                  3        	     K.    set_envelope_state                3u             K.    get_envelope_state                3             K.    envelope_read_report              4        .     K.    envelope_clear                    5}         !     K.    set_datalogger_state              5        "v 'u     K.    get_datalogger_state              6?        (1 .     K.    set_datalogger_name               6        / 6Y     K.    get_datalogger_name               6        7a >     K.    set_datalogger_block_size         7G        ? G     K.    get_datalogger_block_size         7        H# T' 
    K.    set_datalogger_filter             8	        W cl 
    K.    get_datalogger_filter             8q        f k     K.    datalogger_clear_block            8        l s>     K.    set_active_datalogger_block       96        t y     K.    get_active_datalogger_block       9        zF       K.    datalogger_read_num_counts        :	        ( D     K.    datalogger_read_block             :              K.    datalogger_read_eval_values       <             K.    system_set_register               =        ;     K.    system_get_register               =c             K.    system_date_time                  =        Y     K.    system_error                      >             K.    system_keyboard                   ?             K.    cal_state                         @I             K.    cal_fres                          @        Ƅ     K.    cal_20mV_mode                     A7             K.    cal_20mV_init                     C        Б     K.    cal_20mV                          D.        f     K.    cal_voltage_mode                  E             K.    cal_voltage                       E        /     K.    cal_current                       FR             K.    cal_pt100_mode                    G             K.    cal_pt100                         H             K.    send_scpi                         H             K.    receive_scpi                      I        M     K.    close                                                                     kInitialize                           DInitialize GPIB                      DInitialize Serial                    DLocal (GPIB only)                   
"Configure                            DSet Config Measurement               DGet Config Measurement              Config Range                         DSet Config Range                     DGet Config Range                     DSet Config Auto Range                DGet Config Auto Range               Config Display                       DSet Config Display Mode              DGet Config Display Mode              DSet Config Display Options           DGet Config Display Options           DSet Config Display Contrast          DGet Config Display Contrast         8Config Temperature Compensation      DSet Config Temp. Compensation        DGet Config Temp. Compensation        DGet Temperature Value                DSet Config Scale  PT100              DGet Config Scale  PT100              DSet Config Scale  U/I Input          DGet Config Scale  U/I Input          DSet Config Temp. Coefficient         DGet Config Temp. Coefficient         DSet Active Temp. Coefficient         DGet Active Temp. Coefficient         DSet Config Device Access             DGet Config Device Access            #Config Printer                       DSet Config Printer State             DSet Config Printer Mode              DGet Config Printer Mode              DReset Printer Counter Reset         %Store/Load Configuration             DSet Memory Label                     DGet Memory Label                     DSet Memory No.                       DGet Memory No.                      (nMeasure                              DMeasure Start                        DMeasure Read                         DMeasure Read String                  DMeasure Stop                        +KComparator                           DSet Config Comparator Mode           DGet Config Comparator Mode           DSet Config 2 Limit Comparator        DGet Config 2 Limit Comparator        DSet Config 4 Limit Comparator        DGet Config 4 Limit Comparator        DRead 2 Limit Comparator Report       DRead 4 Limit Comparator Report       DClear Comparator                    2Envelope (Min/Max-Function)          DSet Envelope State                   DGet Envelope State                   DRead Envelope Report                 DClear Envelope                      4Datalogger                           DSet Datalogger State                 DGet Datalogger State                 DSet Datalogger Name                  DGet Datalogger Name                  DSet Datalogger Block Size            DGet Datalogger Block Size            DSet Datalogger Filter                DGet Datalogger Filer                 DClear Datalogger Block               DSet Active Datalogger Block          DGet Active Datalogger Block          DRead Datalogger Num. of Counts       DRead Num. of Datalogger Block        DRead Datalogger Eval. Values        ;>System                               DSet Register                         DGet Register                         DSystem Date/Time                     DSystem Error                         DSystem Keyboard                     >yCalibration                          DCalibration State                    DCalibration Resistance Ranges        DCalibration 20mV Mode                DCalibration 20mV Init                DCalibration 20mV                     DCalibration Voltage Mode             DCalibration Voltage                  DCalibration Current                  DCalibration PT100 Mode               DCalibration PT100                   GnSCPI                                 DSend a SCPI-Message                  DReceive a SCPI-Message               DClose                           